using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_DataInputA : ucBase
    {
        //public string _fileName;
        public static int intPage = 0;
        string path = "";
        public uc_DataInputA()
        {
            InitializeComponent();
            #region Language added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_DataInputA_Load(object sender, EventArgs e)
        {
            try
            {
                cboPointA.Items.Add("point");
                cboSpatialA.Items.Add("spatial field");
                cboSpatialA.Items.Add("grad adj spatial field");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

    
        /// <summary>
        /// Initialize Control
        /// add by Devin
        /// 20190724
        /// </summary>
        public void InitializeControl()
        {
            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA == null)
            {
                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA = new DataInputA();
                rbtnMonitorFileA.Checked = true;
                if (CommonClass.dicExampleConfiguration != null)
                {
                    CommonClass.speciesMonitorFile = CommonClass.dicExampleConfiguration["AnnualPM"]["speciesMonitorDataFile"];
                    txtMonitorFileA.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                    cboPointA.SelectedIndex = 0;
                    cboSpatialA.SelectedIndex = 0;
                    CommonClass.unofficialPMFile = CommonClass.dicExampleConfiguration["AnnualPM"]["unofficialMonitorDataFile"];
                    txtUnofficialMonitorA.Text = Path.GetFileName(CommonClass.unofficialPMFile);
                    CommonClass.officialPMFile = CommonClass.dicExampleConfiguration["AnnualPM"]["officialMonitorDataFile"];
                    txtOfficialMonitorA.Text = Path.GetFileName(CommonClass.officialPMFile);
                    rbtnDailyModelA.Checked = true;
                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["baselineModelDataFile"];
                    txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["forecastModelDataFile"];
                    txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                }
            }
            else
            {
                rbtnMonitorFileA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doSpeciesMonitorDataFile;
                CommonClass.speciesMonitorFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.speciesMonitorDataFile;
                txtMonitorFileA.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                rbtnFractionA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doSpeciesFractionFile;
                cboPointA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.specFracModePoint;
                CommonClass.speciesFractionFilePoint = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.specFracPointFile;
                txtFractionPointA.Text = Path.GetFileName(CommonClass.speciesFractionFilePoint);
                cboSpatialA.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.specFracModeSpatial;
                CommonClass.speciesFractionFileSpatial = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.specFracSpatialFile;
                txtFractionSpatialA.Text = Path.GetFileName(CommonClass.speciesFractionFileSpatial);
                CommonClass.unofficialPMFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.unofficialMonitorDataFile;
                txtUnofficialMonitorA.Text = Path.GetFileName(CommonClass.unofficialPMFile);
                CommonClass.officialPMFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.officialMonitorDataFile;
                txtOfficialMonitorA.Text = Path.GetFileName(CommonClass.officialPMFile);
                rbtnDailyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doDailyModelDataInput;
                rbtnQuarterlyModelA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doQuarterlyModelDataInput;
                rbtnCMAQA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.doInputFromCmaq;
                CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.baselineModelDataFile;
                txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration).dataInputA.forecastModelDataFile;
                txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
            }
        }


        private void btnOpenMonitorFileA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesMonitorFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.speciesMonitorFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesMonitorFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = Language.Localization.GetValue("Select file...");
                openfile.Filter = Language.Localization.GetValue("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    //_fileName = openfile.FileName;
                    CommonClass.speciesMonitorFile = openfile.FileName;
                    txtMonitorFileA.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnFractionPointA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesFractionFilePoint) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.speciesFractionFilePoint)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesFractionFilePoint);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.speciesFractionFilePoint = openfile.FileName;
                    txtFractionPointA.Text = Path.GetFileName(CommonClass.speciesFractionFilePoint);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnFractionSpatialA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesFractionFileSpatial) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.speciesFractionFileSpatial)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesFractionFileSpatial);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.speciesFractionFileSpatial = openfile.FileName;
                    txtFractionSpatialA.Text = Path.GetFileName(CommonClass.speciesFractionFileSpatial);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnUnofficialMonitorA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {

                    if (string.IsNullOrEmpty(CommonClass.unofficialPMFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.unofficialPMFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.unofficialPMFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.unofficialPMFile = openfile.FileName;
                    txtUnofficialMonitorA.Text = Path.GetFileName(CommonClass.unofficialPMFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnOfficialMonitorA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {

                    if (string.IsNullOrEmpty(CommonClass.officialPMFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.officialPMFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.officialPMFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                openfile.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.officialPMFile = openfile.FileName;
                    txtOfficialMonitorA.Text = Path.GetFileName(CommonClass.officialPMFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnBaselineA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.baseModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.baseModelFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.baseModelFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                string filter = "";
                if (rbtnCMAQA.Checked == true)
                {
                    filter = LanguageOld.Translate("All Files(*.*)|*.*");
                }
                else
                {
                    filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                }
                openfile.Filter = filter;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.baseModelFile = openfile.FileName;
                    txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnForecastA_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog openfile = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.futureModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.futureModelFile)))
                    {
                        openfile.InitialDirectory = Application.StartupPath + @"\Data\SampleData";
                    }
                    else
                    {
                        openfile.InitialDirectory = Path.GetDirectoryName(CommonClass.futureModelFile);
                    }
                }
                else
                    openfile.InitialDirectory = path;
                openfile.Title = LanguageOld.Translate("Select file...");
                string filter = "";
                if (rbtnCMAQA.Checked == true)
                {
                    filter = LanguageOld.Translate("All Files(*.*)|*.*");
                }
                else
                {
                    filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                }
                openfile.Filter = filter;
                if (openfile.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.futureModelFile = openfile.FileName;
                    txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                    path = Path.GetDirectoryName(openfile.FileName);
                    openfile.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //species monitor data file
        private void rbtnMonitorFileA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rbtnMonitorFileA.Checked)
                {
                    txtMonitorFileA.Enabled = true;
                    txtMonitorFileA.BackColor = Color.White;
                    btnOpenMonitorFileA.Enabled = true;
                    txtFractionPointA.Enabled = false;
                    txtFractionPointA.BackColor = Color.FromKnownColor(KnownColor.Control);
                    txtFractionSpatialA.Enabled = false;
                    txtFractionSpatialA.BackColor = Color.FromKnownColor(KnownColor.Control);
                    cboPointA.Enabled = false;
                    cboSpatialA.Enabled = false;
                    btnFractionPointA.Enabled = false;
                    btnFractionSpatialA.Enabled = false;
                    txtUnofficialMonitorA.Enabled = true;
                    txtUnofficialMonitorA.BackColor = Color.White;
                    btnUnofficialMonitorA.Enabled = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //species fractions file
        private void rbtnFractionA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                AnnualPMAnalysisConfiguration annualPMAnalysisConfiguration = CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisConfiguration;
                if (annualPMAnalysisConfiguration.outputChoiceAdvancedA != null
                    && (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFilePoint == true
                    || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doNeighborFileSpatial == true))
                {
                    MessageBox.Show(LanguageOld.Translate("Using species fractions file. Disable neighbor file creation."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
                if ((cboSpatialA.Text == "spatial field"||cboSpatialA.Text == "空间网格") && rbtnFractionA.Checked == true && (annualPMAnalysisConfiguration.outputChoiceAdvancedA != null
                    && (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj_GradAdj || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyEvna
                    || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyEvna || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial_GraAdj)))
                {
                    MessageBox.Show(LanguageOld.Translate("Using species fractions file spatial field. Disable eVNA files creation."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
                if ((cboSpatialA.Text == "grad adj spatial field" || cboSpatialA.Text == "梯度调整空间网格") && rbtnFractionA.Checked == true && (annualPMAnalysisConfiguration.outputChoiceAdvancedA != null
                    && (annualPMAnalysisConfiguration.outputChoiceAdvancedA.doInterpolatedSFETempAdj || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doFutureOnlyVNA
                    || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doBaseOnlyVNA || annualPMAnalysisConfiguration.outputChoiceAdvancedA.doSpeciesFractionSpatial)))
                {
                    MessageBox.Show(LanguageOld.Translate("Using gradient-adjustment species fractions file spatial field. Disable VNA files creation."), LanguageOld.Translate("Tip"), MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
                if (rbtnFractionA.Checked)
                {
                    txtMonitorFileA.Enabled = false;
                    txtMonitorFileA.BackColor = Color.FromKnownColor(KnownColor.Control);
                    btnOpenMonitorFileA.Enabled = false;
                    txtFractionPointA.Enabled = true;
                    txtFractionPointA.BackColor = Color.White;
                    txtFractionSpatialA.Enabled = true;
                    txtFractionSpatialA.BackColor = Color.White;
                    cboPointA.Enabled = true;
                    cboSpatialA.Enabled = true;
                    btnFractionPointA.Enabled = true;
                    btnFractionSpatialA.Enabled = true;
                    txtUnofficialMonitorA.Enabled = false;
                    txtUnofficialMonitorA.BackColor = Color.FromKnownColor(KnownColor.Control);
                    btnUnofficialMonitorA.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        //Daily Model Data Input 单选框
        private void rbtnDailyModelA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rbtnDailyModelA.Checked == true)
                {
                    CommonClass.baseModelFile = Application.StartupPath + @"\Data\SampleData\Model_data\SMAT.PM.Large.12.SE_US2.2011eh.camx.grid.csv";//PM_small_USA_12km_2011.csv";
                    CommonClass.futureModelFile = Application.StartupPath + @"\Data\SampleData\Model_data\SMAT.PM.Large.12.SE_US2.2017eh.camx.grid.csv";//PM_small_USA_12km_2018.csv";
                    txtBaselineA.Text = Path.GetFileName(CommonClass.baseModelFile);
                    //txtBaselineA.Text = Application.StartupPath + @"\Data\SampleData\2002cc_EUS_PM25_sub.csv";
                    //txtForecastA.Text = Application.StartupPath + @"\Data\SampleData\2020cc_EUS_PM25_sub.csv";
                    txtForecastA.Text = Path.GetFileName(CommonClass.futureModelFile);
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnQuarterlyModelA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rbtnQuarterlyModelA.Checked == true)
                {
                    txtBaselineA.Text = "";
                    txtForecastA.Text = "";
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnCMAQA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                if (rbtnCMAQA.Checked == true)
                {
                    txtBaselineA.Text = "";
                    txtForecastA.Text = "";
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblSpeciesData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_1_3_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblMonitorData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_1_3_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblModelData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_1_3_data_input.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

    }
}
